%%%--------------------------------------------------------------------
%%% @author Wojciech Geisler
%%% @copyright (C) 2019 ACK CYFRONET AGH
%%% This software is released under the MIT license
%%% cited in 'LICENSE.txt'.
%%% @end
%%%--------------------------------------------------------------------
%%% @doc
%%% Unit tests for service_oz_worker module.
%%% @end
%%%--------------------------------------------------------------------
-module(service_oz_worker_test).
-author("Wojciech Geisler").


-ifdef(TEST).

-include("modules/errors.hrl").
-include("modules/models.hrl").
-include("names.hrl").
-include_lib("eunit/include/eunit.hrl").

-define(FAKE_CONFIG_PATH , "autogenerated.config").

root_passphrase_test_() ->
    {foreach,
        fun start/0,
        fun stop/1,
        zone_policies_should_change_app_config_tests()
    }.


% testcase generator
zone_policies_should_change_app_config_tests() ->
    Cases = [
        {oneprovider_registration, provider_registration_policy, <<"open">>, open},
        {oneprovider_registration, provider_registration_policy, <<"restricted">>, restricted},
        {subdomain_delegation, subdomain_delegation_supported, true, true},
        {subdomain_delegation, subdomain_delegation_supported, false, false},
        {gui_package_verification, gui_package_verification, true, true},
        {gui_package_verification, gui_package_verification, false, false},
        {harvester_gui_package_verification, harvester_gui_package_verification, true, true},
        {harvester_gui_package_verification, harvester_gui_package_verification, false, false}
    ],
    lists:map(fun({Policy, Variable, Input, VariableValue}) ->
        fun() ->
            service_oz_worker:set_policies(#{Policy => Input}),
            ?assertEqual(1, meck:num_calls(onepanel_env, write,
                [[oz_worker, Variable], VariableValue, ?SERVICE_OZW])),
            ?assertEqual(1, meck:num_calls(onepanel_env, set_remote,
                ['_', Variable, VariableValue, '_']))
        end
    end, Cases).


start() ->
    meck:new([onepanel_env], [passthrough]),
    meck:expect(onepanel_env, get_config_path,
        fun(_, _) -> ?FAKE_CONFIG_PATH end),
    meck:expect(onepanel_env, write,
        fun(_Keys, _Value, _ServiceName) -> ok end),
    meck:expect(onepanel_env, set_remote,
        fun(_Node, _Variable, _Value, _AppName) -> ok end).


stop(_) ->
    ?assert(meck:validate([onepanel_env])),
    meck:unload().

-endif.
