"""This module contains test cases for rtransfer"""

__author__ = "Bartek Kryza"
__copyright__ = """(C) 2023 ACK CYFRONET AGH,
This software is released under the MIT license cited in 'LICENSE.txt'."""

import socket
import sys
import pytest
import random
import json
import string
import subprocess
import hashlib
import time
import uuid
import base64
import tempfile
import os
import tempfile
import hashlib
from multiprocessing import Pool

from test_common import *


def test_posix_storage_full_transfer(rtransfer, src_dir, dest_dir):
    # Create temporary file with random data
    random_block = os.urandom(1024*1024)
    file_block_count = 100

    file_size = file_block_count * len(random_block)

    with open(os.path.join(src_dir, "file1.dat"), 'wb') as file1:
        for _ in range(0, file_block_count):
            file1.write(random_block)

    # We have to create empty destination file manually
    with open(os.path.join(dest_dir, "file1.dat"), 'wb') as file1:
        pass

    (dest, src) = rtransfer
    dest_storage_id = create_posix_helper("dest_posix", dest, str(dest_dir))
    src_storage_id = create_posix_helper("src_posix", src, str(src_dir))
    conns = connect_links(dest, src)

    wait_for_connection()

    fetch_offset = 0
    fetch_size = file_size

    srcfd = to_b64("file1.dat")
    destfd = to_b64("file1.dat")

    priority = 1

    do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
             destfd, fetch_offset, fetch_size, priority)

    assert str(fetch_size) == dest.get_response(skip_updates=True)["wrote"]

    assert hashlib.md5(open(os.path.join(src_dir, "file1.dat"),'rb').read()).hexdigest() \
           == hashlib.md5(open(os.path.join(dest_dir, "file1.dat"),'rb').read()).hexdigest()
