#pragma once

#include <wangle/channel/Handler.h>

namespace rtransfer {

/**
 * @c EventBaseHandler is very similar to @c wangle::EventBaseHandler, but it
 * doesn't block in `write`.
 * This avoids potential deadlocks while sacrificing synchronization on write
 * (which we don't really need, and which is only half a thing for sockets
 * anyway, since write() returns after data is put into a buffer, not after it
 * goes out a socket).
 */
class EventBaseHandler : public wangle::OutboundBytesToBytesHandler {
public:
    folly::Future<folly::Unit> write(
        Context* ctx, std::unique_ptr<folly::IOBuf> buf) override
    {
        return via(ctx->getTransport()->getEventBase())
            .thenValue([ctx, buf = std::move(buf)](auto&& /*unit*/) mutable {
                return ctx->fireWrite(std::move(buf));
            });
    }

    folly::Future<folly::Unit> close(Context* ctx) override
    {
        return via(ctx->getTransport()->getEventBase())
            .thenValue([ctx](auto&& /*unit*/) { return ctx->fireClose(); });
    }
};

}  // namespace rtransfer
