#pragma once

#include <algorithm>
#include <array>

namespace rtransfer {
namespace bbr {

class BtlBwFilter {
public:
    void add(double bw)
    {
        filter_[front_] = bw;
        max_ = std::max_value(filter_.begin(), filter_.end());
        front_ = (front_ + 1) % filter_.size();
    }

    double max() { return max_; }

private:
    std::array<double, 10> filter_{};
    std::size_t front_ = 0;
    double max_ = 0;
}

}  // namespace bbr
}  // namespace rtransfer
