"""This module contains test cases for error handling in rtransfer"""

__author__ = "Bartek Kryza"
__copyright__ = """(C) 2023 ACK CYFRONET AGH,
This software is released under the MIT license cited in 'LICENSE.txt'."""

import socket
import sys
import pytest
import random
import json
import string
import subprocess
import hashlib
import time
import uuid
import base64
import tempfile
import os
import tempfile
import hashlib
from multiprocessing import Pool

from test_common import *

def test_cancel_normal_transfer(rtransfer):
    (dest, src) = rtransfer
    dest_storage_id = create_null_helper("dest_null", dest)
    src_storage_id = create_slow_null_helper("src_slow_null", src)
    conns = connect_links(dest, src)

    wait_for_connection()

    fetch_offset = 0
    fetch_size = 1000*1000*1000

    srcfd = to_b64("/file1.txt")
    destfd = to_b64("/file1.txt")

    priority = 1

    fetch_req_id = do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
             destfd, fetch_offset, fetch_size, priority)

    # Skip first 2 update messages
    for i in range(0, 2):
        resp = dest.get_response(skip_updates=False)
        assert "isUpdate" in resp and resp["isUpdate"]

    cancel_req_id = do_cancel(dest, conns[0], src_storage_id, dest_storage_id, fetch_req_id)

    got_fetch_resp = False
    got_cancel_resp = False
    while got_fetch_resp and got_cancel_resp:
        resp = dest.get_response(skip_updates=True)
        if resp["reqId"] == cancel_req_id:
            assert resp["done"]
            got_cancel_resp = True
        elif resp["reqId"] == fetch_req_id:
            assert resp["error"]["description"] == "canceled"
            got_fetch_resp = True
