"""This module contains test cases for error handling in rtransfer"""

__author__ = "Bartek Kryza"
__copyright__ = """(C) 2023 ACK CYFRONET AGH,
This software is released under the MIT license cited in 'LICENSE.txt'."""

import socket
import sys
import pytest
import random
import json
import string
import subprocess
import hashlib
import time
import uuid
import base64
import tempfile
import os
import tempfile
import hashlib
from multiprocessing import Pool

from test_common import *

def test_handle_read_timeout_error(rtransfer):
    (dest, src) = rtransfer
    dest_storage_id = create_null_helper("dest_null", dest)
    src_storage_id = create_busy_null_helper("src_busy_null", src)
    conns = connect_links(dest, src)

    wait_for_connection()

    srcfd = to_b64("file1.dat")
    destfd = to_b64("file1.dat")

    fetch_offset = 0
    fetch_size = 1*1000*1000*1000

    priority = 1

    do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
             destfd, fetch_offset, fetch_size, priority)

    resp = dest.get_response(skip_updates=True)

    assert resp["error"]["description"] == "Resource temporarily unavailable"


def test_handle_read_file_not_found_error(rtransfer):
    (dest, src) = rtransfer
    dest_storage_id = create_null_helper("dest_null", dest)
    src_storage_id = create_posix_helper("src_posix", src, "/tmp")
    conns = connect_links(dest, src)

    wait_for_connection()

    srcfd = to_b64("file1.dat")
    destfd = to_b64("file1.dat")

    fetch_offset = 0
    fetch_size = 1024

    priority = 1

    do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
             destfd, fetch_offset, fetch_size, priority)

    resp = dest.get_response(skip_updates=True)

    assert resp["error"]["description"] == "No such file or directory"

def test_handle_write_file_not_found_error(rtransfer):
    (dest, src) = rtransfer
    dest_storage_id = create_posix_helper("dest_posix", dest, "/tmp")
    src_storage_id = create_null_helper("src_null", src)
    conns = connect_links(dest, src)

    wait_for_connection()

    srcfd = to_b64("file1.dat")
    destfd = to_b64("file1.dat")

    fetch_offset = 0
    fetch_size = 1024

    priority = 1

    do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
             destfd, fetch_offset, fetch_size, priority)

    assert dest.get_response()["error"]["description"] == "No such file or directory"

@pytest.mark.skip()
def test_handle_quota_exceeded_error(rtransfer):
    (dest, src) = rtransfer
    dest_storage_id = create_null_helper("dest_null", dest)
    src_storage_id = create_null_helper("src_null", src)
    conns = connect_links(dest, src)

    wait_for_connection()

    srcfd = to_b64("file1.dat")
    destfd = to_b64("file1.dat")

    fetch_offset = 0
    fetch_size = 10*1024*1024*1024 # 10GB

    priority = 1

    req_id = do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
                      destfd, fetch_offset, fetch_size, priority)

    # Skip first 5 update messages
    for i in range(0, 5):
        resp = p1.get_response(skip_updates=False)

    do_cancel(dest, conns[0], src_storage_id, dest_storage_id, req_id)

    assert dest.get_response()["error"]["description"] == "No such file or directory"
