/**
 * @file testRunner.cc
 * @author Konrad Zemek
 * @copyright (C) 2014 ACK CYFRONET AGH
 * @copyright This software is released under the MIT license cited in
 * 'LICENSE.txt'
 */

#include <folly/init/Init.h>
#include <glog/logging.h>
#include <gmock/gmock.h>
#include <gtest/gtest.h>

#define BACKWARD_HAS_DW 1
#define BACKWARD_HAS_UNWIND 1
#include <backward.hpp>

int main(int argc, char *argv[])
{
    ::testing::InitGoogleTest(&argc, argv);
    ::testing::InitGoogleMock(&argc, argv);
    folly::init(&argc, &argv, false);
    FLAGS_alsologtostderr = false;
    FLAGS_stderrthreshold = 3;
    return RUN_ALL_TESTS();
}
