#
# - Try to find onedata helpers library
# This will define
# ONEDATA_HELPERS_FOUND
# ONEDATA_HELPERS_INCLUDE_DIR
# ONEDATA_HELPERS_LIBRARY
#

find_path(
    ONEDATA_HELPERS_INCLUDE_DIR
    NAMES "helpers/storageHelper.h"
    PATHS "${ONEDATA_HELPERS_DIR}/include"
    HINTS "/usr/local/include"
)

find_library(
    ONEDATA_HELPERS_LIBRARY
    NAMES helpers
    PATHS "${ONEDATA_HELPERS_DIR}/lib"
    HINTS "/usr/local/lib"
)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    ONEDATA_HELPERS DEFAULT_MSG ONEDATA_HELPERS_INCLUDE_DIR ONEDATA_HELPERS_LIBRARY)

mark_as_advanced(ONEDATA_HELPERS_INCLUDE_DIR ONEDATA_HELPERS_LIBRARY ONEDATA_HELPERS_FOUND)

if(ONEDATA_HELPERS_FOUND AND NOT ONEDATA_HELPERS_FIND_QUIETLY)
    message(STATUS "ONEDATA_HELPERS: ${ONEDATA_HELPERS_INCLUDE_DIR}")
endif()
