%%%-------------------------------------------------------------------
%%% @author Konrad Zemek
%%% @copyright (C) 2017 ACK CYFRONET AGH
%%% This software is released under the MIT license
%%% cited in 'LICENSE.txt'.
%%% @end
%%%-------------------------------------------------------------------
%%% @doc
%%% @end
%%%-------------------------------------------------------------------
-module(rtransfer_link_connection_sup).
-author("Konrad Zemek").

-behaviour(supervisor).

%%%===================================================================
%%% Exports
%%%===================================================================

-export([start_link/0, init/1]).

%%%===================================================================
%%% API
%%%===================================================================

-spec start_link() -> {ok, pid()} | {error, any()}.
start_link() ->
    supervisor:start_link({local, ?MODULE}, ?MODULE, []).

%%%===================================================================
%%% supervisor callbacks
%%%===================================================================

init(_) ->
    SupFlags = #{strategy => simple_one_for_one,
                 intensity => 10000, period=> 1},
    Children = [#{id => rtransfer_link_connection,
                  start => {rtransfer_link_connection, start_link, []},
                  restart => temporary,
                  shutdown => 10000,
                  type => worker,
                  modules => [rtransfer_link_connection]}],
    {ok, {SupFlags, Children}}.
