%%%-------------------------------------------------------------------
%%% @author Piotr Duleba
%%% @copyright (C) 2021 ACK CYFRONET AGH
%%% This software is released under the MIT license
%%% cited in 'LICENSE.txt'.
%%% @end
%%%-------------------------------------------------------------------
%%% @doc
%%% Definitions of macros for variables that are defined in charts.
%%% @end
%%%-------------------------------------------------------------------

-ifndef(CHART_VALUES_HRL).
-define(CHART_VALUES_HRL, 1).

-define(PROVIDER_KRAKOW_GEO_LATITUDE, 50.0647).
-define(PROVIDER_KRAKOW_GEO_LONGITUDE, 19.945).
-define(PROVIDER_PARIS_GEO_LATITUDE, 48.8566).
-define(PROVIDER_PARIS_GEO_LONGITUDE, 2.3522).

-define(POSIX_MOUNTPOINT, <<"/volumes/posix">>).

-define(S3_HOSTNAME, <<"volume-s3.dev-volume-s3-krakow:9000">>).
-define(S3_KEY_ID, <<"accessKey">>).
-define(S3_ACCESS_KEY, <<"verySecretKey">>).
-define(S3_BUCKET_NAME, <<"test">>).
-define(S3_DEFAULT_BLOCK_SIZE, 10485760).
-define(S3_MIN_BLOCK_SIZE, 0).
-define(S3_DEFAULT_MAX_CANONICAL_OBJECT_SIZE, 67108864).
-define(S3_MIN_MAX_CANONICAL_OBJECT_SIZE, 1).
-define(S3_ALLOWED_SIGNATURE_VERSIONS, [4]).
-define(S3_DEFAULT_SIGNATURE_VERSIONS, 4).

-define(WEBDAV_ENDPOINT, <<"http://dev-volume-webdav-krakow.default">>).
-define(WEBDAV_BASIC_CREDENTIALS, <<"tester:testing">>).

-define(CEPH_MONITOR_HOSTNAME, <<"dev-volume-ceph-krakow.default">>).
-define(CEPH_CLUSTER_NAME, <<"ceph">>).
-define(CEPH_POOL_NAME, <<"test">>).
-define(CEPH_USERNAME, <<"client.k8s">>).
-define(CEPH_KEY, <<"AQC1oSZZZfucFxAA34MekwoWBm7qpGd0A8u+fg==">>).


-define(GLUSTERFS_VOLUME, <<"test">>).
-define(GLUSTERFS_HOSTNAME, <<"dev-volume-gluster-krakow.default">>).
-define(GLUSTERFS_PORT, 24007).
-define(GLUSTERFS_TRANSPORT, <<"tcp">>).

-endif.