/**
 * @file util_cdmi_test.cc
 * @author Bartek Kryza
 * @copyright (C) 2018 ACK CYFRONET AGH
 * @copyright This software is released under the MIT license cited in
 * 'LICENSE.txt'
 */

#include "util/cdmi.h"

#include <gtest/gtest.h>

using namespace ::testing;
using namespace one::client::util::cdmi;

struct CDMITest : public ::testing::Test {
};

TEST_F(CDMITest, fileUuidToObjectIdShouldWork)
{
    ASSERT_EQ(uuidToObjectId("Z3VpZCNmMDQ2NmFkZTJiZGYwMmJmYTllZTkzZmViMzhjNDc3M"
                             "iNlMjYzZjUyNzA0NmFjOGExZjVkZmU5YzBjNDhmODE1OQ"),
        "0000000000469467677569642366303436366164653262646630326266613965653933"
        "6665623338633437373223653236336635323730343661633861316635646665396330"
        "6334386638313539");

    ASSERT_EQ(uuidToObjectId("Z3VpZCNiZWQ1YjNmN2QyNTEwMTg0ZTFiMmI5MzBmZjdjMjFlZ"
                             "GNoMTI2MiMzMWI5NDJkYW"
                             "QyZDJjMWFmZDE0ZTEzNGZhZmVjYWU2M2NoMTI2Mg"),
        "000000000052004F677569642362656435623366376432353"
        "130313834653162326239"
        "3330666637633231656463683132363223333162393432646"
        "164326432633161666431"
        "3465313334666166656361653633636831323632");
}

TEST_F(CDMITest, fileObjectIdToUUIDShouldWork)
{
    ASSERT_EQ(
        objectIdToUUID("0000000000469467677569642366303436366164653262646630326"
                       "2666139656539336665623338633437373223653236336635323730"
                       "3436616338613166356466653963306334386638313539"),
        "Z3VpZCNmMDQ2NmFkZTJiZGYwMmJmYTllZTkzZmViMzhjNDc3MiNlMjYzZjUyNzA0NmFjOG"
        "ExZjVkZmU5YzBjNDhmODE1OQ");

    ASSERT_EQ(objectIdToUUID("000000000052004F677569642362656435623366376432353"
                             "130313834653162326239"
                             "3330666637633231656463683132363223333162393432646"
                             "164326432633161666431"
                             "3465313334666166656361653633636831323632"),
        "Z3VpZCNiZWQ1YjNmN2QyNTEwMTg0ZTFiMmI5MzBmZjdjMjFlZGNoMTI2MiMzMWI5NDJkYW"
        "QyZDJjMWFmZDE0ZTEzNGZhZmVjYWU2M2NoMTI2Mg");
}
