%%%-------------------------------------------------------------------
%%% @author Piotr Duleba
%%% @copyright (C) 2021 ACK CYFRONET AGH
%%% This software is released under the MIT license
%%% cited in 'LICENSE.txt'.
%%% @end
%%%-------------------------------------------------------------------
%%% @doc
%%% Definitions of macros and records used in storage API (REST) tests.
%%% @end
%%%-------------------------------------------------------------------
-author("Piotr Duleba").

-ifndef(API_TEST_STORAGES_HRL).
-define(API_TEST_STORAGES_HRL, 1).

-include("api_test_runner.hrl").

-record(add_storage_test_spec, {
    storage_type = undefined :: api_oneprovider_storages_test_base:storage_type(),
    args_correctness = undefined :: api_oneprovider_storages_test_base:args_correctness(),

    data_spec_fun :: api_oneprovider_storages_test_base:data_spec_builder(),
    prepare_args_fun :: api_oneprovider_storages_test_base:prepare_args_fun_builder(),
    data_spec_random_coverage = 100 :: api_oneprovider_storages_test_base:data_spec_random_coverage()
}).

-record(modify_storage_test_spec, {
    storage_type = undefined :: api_oneprovider_storages_test_base:storage_type(),
    args_correctness = undefined :: api_oneprovider_storages_test_base:args_correctness(),

    build_data_spec_fun :: api_oneprovider_storages_test_base:data_spec_builder(),
    build_setup_fun :: api_oneprovider_storages_test_base:setup_fun_builder(),
    build_prepare_args_fun :: api_oneprovider_storages_test_base:prepare_args_fun_builder(),

    map_storage_description_to_exp_rest_response_fun = fun(Desc) -> Desc end :: fun((json_utils:json_map()) -> json_utils:json_map())
}).

-define(STORAGE_DETECTION_FILE_SIZE, 10000).

-define(STORAGE_DATA_KEY(StorageName, Key), iolist_to_binary([StorageName, <<".">>, Key])).
-define(SUPPORT_SIZE, 10000000).
-define(ATTEMPTS, 60).
-define(STORAGE_TYPES, [
    <<"cephrados">>,
    <<"glusterfs">>,
    <<"http">>,
    <<"nfs">>,
    <<"nulldevice">>,
    <<"posix">>,
    <<"s3">>,
    <<"swift">>,
    <<"webdav">>,
    <<"xrootd">>
]).
-define(MODIFY_STORAGE_TYPES, [
    <<"ceph">>,
    <<"cephrados">>,
    <<"glusterfs">>,
    <<"http">>,
    <<"nfs">>,
    <<"nulldevice">>,
    <<"posix">>,
    <<"s3">>,
    <<"swift">>,
    <<"webdav">>,
    <<"xrootd">>
]).
-define(STORAGE_TIMEOUT, 20000).
-define(STORAGE_QOS_PARAMETERS, #{
    <<"key">> => <<"value">>
}).

-endif.
