# Client-server protocol

## Authentication

Prior to setting up a link, the two involved providers communicate with each other using previously established secure channels.
A client provider sends a randomly generated 64-byte secret to the server provider, which responds with its own 64-byte secret.
Through this exchange, when the secrets are shared on the new connections created by rtransfer, both ends of rtransfer are sure they are connected to the provider they are supposed to be connected to.

## Control connection

To establish a link, first of all, a control connection is created.

After connecting, client sends a HTTP header:

```
GET /rtransfer HTTP/1.1
Host: <hostname>
Connection: upgrade
Upgrade: clproto
```

The hostname doesn't really matter.

Then, the client sends bytes `rtransfer`, and then two bytes that signify the version of the client's protocol (currently, the version is `00` in acii), followed by 64-byte client secret and `0000000000000000` (ascii) which is a 16-byte blank ctrlId that signifies a new control connection.

The server responds with a HTTP response:

```
101
Connection: upgrade
Upgrade: clproto
```

followed by 64-byte server secret, followed by the negotiated version (in principle this should be the lower of the server's protocol version and the protocol version sent by the client; currently it's just `00` ascii), and finally followed by 16-byte ctrlId assigned for the new link.

After the handshake is complete, the messages sent are protobuf messages defined in rtransfer_messages.proto

### Example handshake

Example bytes sent by the client:

```
GET /rtransfer HTTP/1.1\n
Host: prov.otc.com\n
Connection: upgrade\n
Upgrade: clproto\n
rtransfer00clientsecretclientsecretclientsecretclientsecretclientsecretcl0000000000000000
```

example bytes sent in response by the server:

```
101\n
Connection: upgrade\n
Upgrade: clproto\n
serversecretserversecretserversecretserversecretserversecretse00abcdef0123456789
```

## Data connection

After establishing a control connection, data connections can be attached to it to form a link.
To establish a data connection, client sends the same data as when establishing control connection - the only difference is the ctrlId which is now set to the value returned by the server when establishing the control connection.

As with the control connection, the server responds with a HTTP response:

```
101
Connection: upgrade
Upgrade: clproto
```

followed by 64-byte server secret.

After the handshake is complete, the only thing sent from the client to server are arbitrary bytes that mean "ping", as a keepalive mechanism.
Meantime, the server sends messages containing requested data in the following format:

1. 64-bit unsigned big-endian reqId of the fetch
2. 1-bit flag: `1` if this is the last part of the message, `0` if not
3. 7-bit unsigned part number
4. 64-bit unsigned big-endian offset of the message
5. 32-bit unsigned big-endian size of the part
6. part data

On the client side, the message parts are buffered until all of them have been received (parts can come over different sockets), then combined into a single message.
A message is identified by its reqId and offset.

### Example handshake

Example bytes sent by the client:

```
GET /rtransfer HTTP/1.1\n
Host: prov.otc.com\n
Connection: upgrade\n
Upgrade: clproto\n
rtransfer00clientsecretclientsecretclientsecretclientsecretclientsecretclabcdef0123456789
```

example bytes sent in response by the server:

```
101\n
Connection: upgrade\n
Upgrade: clproto\n
serversecretserversecretserversecretserversecretserversecretse
```
