macro(find_library_prefer_static)
    set(CMAKE_FIND_LIBRARY_SUFFIXES_OLD ${CMAKE_FIND_LIBRARY_SUFFIXES})
    set(CMAKE_FIND_LIBRARY_SUFFIXES .a)
    find_library(${ARGV})
    set(CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES_OLD})

    if(NOT ${ARGV0})
        message(STATUS "Unable to find static library '${ARGV1}'")
        find_library(${ARGV})
    endif()

    if(NOT ${ARGV0})
        message(FATAL_ERROR "Unable to find library '${ARGV1}'")
    endif()
endmacro(find_library_prefer_static)

macro(find_package_prefer_static)
    set(CMAKE_FIND_LIBRARY_SUFFIXES_OLD ${CMAKE_FIND_LIBRARY_SUFFIXES})
    set(CMAKE_FIND_LIBRARY_SUFFIXES .a)
    find_package(${ARGV})
    set(CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES_OLD})

    if(NOT ${ARGV0}_FOUND)
        message(STATUS "Unable to find static package '${ARGV0}'")
        find_package(${ARGV})
    endif()

    if(NOT ${ARGV0}_FOUND)
        message(FATAL_ERROR "Unable to find package '${ARGV0}'")
    endif()
endmacro(find_package_prefer_static)
