%%%-------------------------------------------------------------------
%%% @author Konrad Zemek
%%% @copyright (C) 2017 ACK CYFRONET AGH
%%% This software is released under the MIT license
%%% cited in 'LICENSE.txt'.
%%% @end
%%%-------------------------------------------------------------------
%%% @doc
%%% @end
%%%-------------------------------------------------------------------
-module(rtransfer_link_sup).
-author("Konrad Zemek").

-behaviour(supervisor).

%%%===================================================================
%%% Exports
%%%===================================================================

-export([start_link/0, start_link/1, init/1]).

%%%===================================================================
%%% API
%%%===================================================================

-spec start_link() -> {ok, pid()} | {error, any()}.
start_link() ->
    start_link(cluster).

-spec start_link(Cluster :: no_cluster | term()) -> {ok, pid()} | {error, any()}.
start_link(Cluster) ->
    supervisor:start_link({local, ?MODULE}, ?MODULE, Cluster).

%%%===================================================================
%%% supervisor callbacks
%%%===================================================================

init(Cluster) ->
    ets:new(rtransfer_link_storages, [public, named_table, {keypos, 2}]),
    ets:new(rtransfer_link_requests, [public, named_table]),
    ets:new(rtransfer_link_provider_nodes,
            [public, named_table, {read_concurrency, true}]),

    PortMod = application:get_env(rtransfer_link, port_mod, rtransfer_link_port),
    SupFlags = #{strategy => one_for_all,
                 intensity => 100,
                 period => 1},
    Children = [
                #{id => PortMod,
                  start => {PortMod, start_link, []},
                  restart => permanent,
                  shutdown => 10000,
                  type => worker,
                  modules => [PortMod]},
                #{id => rtransfer_link_connection_sup,
                  start => {rtransfer_link_connection_sup, start_link, []},
                  restart => permanent,
                  shutdown => 10000,
                  type => supervisor,
                  modules => [rtransfer_link_connection_sup]},
                #{id => rtransfer_link_quota_manager,
                  start => {rtransfer_link_quota_manager, start_link, []},
                  restart => permanent,
                  shutdown => 10000,
                  type => worker,
                  modules => [rtransfer_link_quota_manager]
                 },
                #{id => rtransfer_link,
                  start => {rtransfer_link, start_link, []},
                  restart => permanent,
                  shutdown => 10000,
                  type => worker,
                  modules => [rtransfer_link]} |
                [#{id => rtransfer_link_cluster,
                  start => {rtransfer_link_cluster, start_link, []},
                  restart => permanent,
                  shutdown => 10000,
                  type => worker,
                  modules => [rtransfer_link_cluster]} || Cluster /= no_cluster]
               ],
    {ok, {SupFlags, Children}}.
