"""This module contains test cases for error handling in rtransfer"""

__author__ = "Bartek Kryza"
__copyright__ = """(C) 2023 ACK CYFRONET AGH,
This software is released under the MIT license cited in 'LICENSE.txt'."""

import pytest
import base64

from test_common import *

@pytest.mark.skip()
def test_fetch_request(rtransfer):
    (dest, src) = rtransfer
    dest_storage_id = create_null_helper("dest_null", dest)
    src_storage_id = create_null_helper("src_null", src)
    conns = connect_links(dest, src)

    wait_for_connection()
    wait_for_connection()
    wait_for_connection()

    for conn_id in conns:
        do_fetch_on_all_connections(dest, src, dest_storage_id, src_storage_id, conn_id)

def test_ideal_null_storage_full_transfer(rtransfer):
    (dest, src) = rtransfer
    dest_storage_id = create_null_helper("dest_null", dest)
    src_storage_id = create_null_helper("src_null", src)
    conns = connect_links(dest, src)

    wait_for_connection()

    fetch_offset = 0
    fetch_size = 100*1000*1000

    srcfd = to_b64("/file1.txt")
    destfd = to_b64("/file1.txt")

    priority = 1

    do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
             destfd, fetch_offset, fetch_size, priority)

    assert str(fetch_size) == dest.get_response(skip_updates=True)["wrote"]

def test_destination_is_slow_null_storage_full_transfer(rtransfer):
    (dest, src) = rtransfer
    dest_storage_id = create_slow_null_helper("dest_slow_null", dest)
    src_storage_id = create_null_helper("src_null", src)
    conns = connect_links(dest, src)

    wait_for_connection()

    fetch_offset = 0
    fetch_size = 10*1000*1000

    srcfd = to_b64("/file1.txt")
    destfd = to_b64("/file1.txt")

    priority = 1

    do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
             destfd, fetch_offset, fetch_size, priority)

    assert str(fetch_size) == dest.get_response(skip_updates=True)["wrote"]

def test_source_is_slow_null_storage_full_transfer(rtransfer):
    (dest, src) = rtransfer
    dest_storage_id = create_null_helper("dest_null", dest)
    src_storage_id = create_slow_null_helper("src_slow_null", src)
    conns = connect_links(dest, src)

    wait_for_connection()

    fetch_offset = 0
    fetch_size = 10*1000*1000

    srcfd = to_b64("/file1.txt")
    destfd = to_b64("/file1.txt")

    priority = 1

    do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
             destfd, fetch_offset, fetch_size, priority)

    assert str(fetch_size) == dest.get_response(skip_updates=True)["wrote"]

@pytest.mark.parametrize("fetch_offset,fetch_size",
                         [(0, 1), (5, 1), (1000000, 1024),
                          (500, 1024*1024), (10, 160*1024*1024)])
def test_data_consistency_null_storage_transfer(rtransfer,fetch_offset,fetch_size):
    (dest, src) = rtransfer
    dest_storage_id = create_verifying_null_helper("dest_null", dest)
    src_storage_id = create_verifying_null_helper("src_null", src)
    conns = connect_links(dest, src)

    wait_for_connection()

    srcfd = to_b64("/file1.txt")
    destfd = to_b64("/file1.txt")

    priority = 1

    do_fetch(dest, src, conns[0], src_storage_id, srcfd, dest_storage_id,
             destfd, fetch_offset, fetch_size, priority)

    assert str(fetch_size) == dest.get_response(skip_updates=True)["wrote"]
