"use strict";

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

/**
 * This script is added to the user-provided template of custom frontpage (login screen)
 * for Onezone GUI.
 *
 * The custom frontpage is created by the user and put onto the Onezone server by admin.
 * Onezone GUI renders an iframe that displays `index.html` with user-created custom frontpage
 * and injects this script (integration script) and basic stylesheet into the custom frontpage.
 *
 * The script has some data and API injected from Onezone GUI main window, which allows to
 * push the data and invoke commands in the application (see `FrontpageApi.model` getter).
 *
 * The custom template contains special HTML elements which are populated and managed by this script.
 * Views are managed using a state machine - see implementaion of:
 * - `FrontpageState` enum
 * - `FrontpageApi.setState`
 *
 * @author Jakub Liput
 * @copyright (C) 2024 ACK CYFRONET AGH
 * @license This software is released under the MIT license cited in 'LICENSE.txt'.
 */
// This script is invoked in the context of index.html of custom frontpage, so allow
// to use browser globals (they cannot be imported anyway).

/* eslint no-restricted-globals: ["off"] */

/* eslint promise/no-native: ["off"] */

/**
 * @typedef {Object} Authenticator
 * @property {'basicAuth'|string} id
 * @property {string} iconPath
 * @property {string} iconBackgroundColor
 * @property {string} displayName
 */

/**
 * @typedef {Object} FrontpageModelApi
 * @property {(username: string, password: string) => void} usernameAuthenticate
 * @property {(frontpageApi: FrontpageApi) => void} registerFrontpageApi
 * @property {(authenticatorName: string) => void} authenticate
 * @property {() => {message: string, refId: string, isContactInfo: boolean}} getAuthenticationError
 */

/**
 * @typedef {Object} FrontpageModelData
 * @property {Array<Authenticator>} availableAuthenticators
 * @property {string} loginMessage
 * @property {boolean} isAuthenticationError
 * @property {string} [privacyPolicyUrl]
 * @property {string} [termsOfUseUrl]
 * @property {string} version
 * @property {string} versionBuild
 * @property {boolean} sessionHasExpired
 * @property {boolean} isDomainMismatch
 */

/**
 * @typedef {Object} FrontpageModel
 *
 * @property {FrontpageModelApi} api
 * @property {FrontpageModelData} data
 * @property {Object} i18n
 */

/**
 * @typedef {'Init'|'Buttons'|'Form'|'ButtonAuthenticating'|'FormAuthenticating'|'Error'|'FormError','Final'} FrontpageStateValue
 */

/**
 * Changes must be synchronized with the definition in Ember application.
 */
var FrontpageState = Object.freeze({
  Init: 'Init',
  Buttons: 'Buttons',
  Form: 'Form',
  ButtonAuthenticating: 'ButtonAuthenticating',
  FormAuthenticating: 'FormAuthenticating',
  Error: 'Error',
  FormError: 'FormError',
  Final: 'Final'
});
var State = FrontpageState;
/**
 * Maps: state -> possible next states
 */

var StateTransitions = Object.freeze({
  [State.Init]: [State.Form, State.Buttons, State.Error],
  [State.Buttons]: [State.Form, State.ButtonAuthenticating],
  [State.Form]: [State.FormAuthenticating, State.Buttons],
  [State.ButtonAuthenticating]: [State.Buttons, State.Final],
  [State.FormAuthenticating]: [State.Error, State.FormError, State.Final],
  [State.FormError]: [State.Form, State.Buttons],
  [State.Error]: [State.Init]
});

class FrontpageApi {
  constructor() {
    /**
     * @type {FrontpageStateValue}
     */
    this.state = undefined;
    /**
     * Optional data to use when entering the new state.
     * @type {any}
     */

    this.stateMetadata = null;
    /**
     * If true, ignore authentication errors stored in cookies on init
     * @type {boolean}
     */

    this.isAuthenticationErrorDismissed = false;
  }

  get isOnlyBasicAuth() {
    var _this$model;

    var authenticators = (_this$model = this.model) === null || _this$model === void 0 || (_this$model = _this$model.data) === null || _this$model === void 0 ? void 0 : _this$model.availableAuthenticators;
    return (authenticators === null || authenticators === void 0 ? void 0 : authenticators.length) === 1 && authenticators[0].id === 'basicAuth';
  }

  get isAuthenticationError() {
    return !this.isAuthenticationErrorDismissed && this.model.data.isAuthenticationError;
  }
  /**
   * @type {FrontpageModel}
   */


  get model() {
    return window.customFrontpageModel;
  }
  /**
   * @type {HTMLElement}
   */


  get buttonsContainer() {
    return document.getElementById('login-buttons-container');
  }
  /**
   * @type {HTMLElement}
   */


  get messageContainer() {
    return document.getElementById('login-message-container');
  }
  /**
   * @type {HTMLElement}
   */


  get formContainer() {
    return document.getElementById('login-form-container');
  }
  /**
   * @type {HTMLFormElement}
   */


  get loginForm() {
    return document.getElementById('login-form');
  }
  /**
   * @type {HTMLElement}
   */


  get errorContainer() {
    return document.getElementById('login-error-container');
  }
  /**
   * @type {HTMLInputElement}
   */


  get usernameInput() {
    return document.getElementById('username-input');
  }
  /**
   * @type {HTMLInputElement}
   */


  get passwordInput() {
    return document.getElementById('password-input');
  }
  /**
   * @type {HTMLButtonElement}
   */


  get formBackButton() {
    return document.getElementById('login-form-back-btn');
  }
  /**
   * @type {HTMLButtonElement}
   */


  get errorBackButton() {
    return document.getElementById('error-back-btn');
  }
  /**
   * @type {HTMLButtonElement}
   */


  get formSignInButton() {
    return document.getElementById('login-form-sign-in-btn');
  }
  /**
   * @type {HTMLDivElement}
   */


  get formErrorContainer() {
    return document.getElementById('login-form-error-container');
  }
  /**
   * @type {HTMLHeadingElement}
   */


  get signInHeader() {
    return document.getElementById('sign-in-header');
  }
  /**
   * @type {HTMLHeadingElement}
   */


  get signInSubheader() {
    return document.getElementById('sign-in-subheader');
  }
  /**
   * @type {HTMLDivElement}
   */


  get footer() {
    return document.getElementById('footer');
  }

  mountFrontpage() {
    this.model.api.registerFrontpageApi(this);
    this.initializeElements();
  }

  initializeElements() {
    this.initLoginButtons();
    this.initLoginMessage();
    this.initLoginForm();
    this.initFooter();
  }
  /**
   * @returns {void}
   */


  initSignInHeader() {
    this.signInHeader.textContent = this.model.i18n.signIn;
  }
  /**
   * @returns {void}
   */


  initLoginButtons() {
    var _this$model$data$avai,
        _this$model2,
        _this = this;

    var elements = [];
    var authenticators = (_this$model$data$avai = (_this$model2 = this.model) === null || _this$model2 === void 0 || (_this$model2 = _this$model2.data) === null || _this$model2 === void 0 ? void 0 : _this$model2.availableAuthenticators) !== null && _this$model$data$avai !== void 0 ? _this$model$data$avai : [];

    var _iterator = _createForOfIteratorHelper(authenticators),
        _step;

    try {
      var _loop = function _loop() {
        var _authenticator$iconBa;

        var authenticator = _step.value;
        var loginIconBox = document.createElement('a');
        loginIconBox.style.backgroundColor = (_authenticator$iconBa = authenticator.iconBackgroundColor) !== null && _authenticator$iconBa !== void 0 ? _authenticator$iconBa : '#ffffff';
        loginIconBox.classList.add('login-icon-box', 'auth-icon', authenticator.id);
        loginIconBox.addEventListener('click', () => {
          if (_this.state === State.Buttons) {
            _this.model.api.authenticate(authenticator.id);
          }
        });

        _this.applyMicrotip(loginIconBox, "".concat(_this.model.i18n.signInUsing, " ").concat(authenticator.displayName));

        var authIconImage = document.createElement('div');
        authIconImage.style.backgroundImage = "url(".concat(authenticator.iconPath, ")");
        authIconImage.classList.add('auth-icon-image');
        var loginIconSpinner = document.createElement('div');
        loginIconSpinner.classList.add('login-icon-spinner', 'hidden');
        loginIconBox.appendChild(authIconImage);
        loginIconBox.appendChild(loginIconSpinner);
        elements.push(loginIconBox);
      };

      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        _loop();
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    var container = this.buttonsContainer;
    container.classList.toggle('hidden', true);
    container.innerHTML = '';

    for (var _i = 0, _elements = elements; _i < _elements.length; _i++) {
      var element = _elements[_i];
      container.appendChild(element);
    }
  }
  /**
   * @returns {void}
   */


  initLoginMessage() {
    var container = this.messageContainer;
    var loginMessage = this.model.data.loginMessage || '';
    var innerHtml = '';

    if (this.model.data.isTestMode) {
      var testModeText = this.model.i18n.signInTestMode;
      innerHtml += "\n      <div class=\"login-notification test-mode-notification login-notification-warning\" >\n        ".concat(testModeText, "\n      </div>\n");
    }

    if (this.model.data.sessionHasExpired) {
      var sessionExpiredText = this.model.i18n.sessionExpiredText;
      innerHtml += "\n      <div class=\"login-notification login-notification-session-expired login-notification-warning\">\n        ".concat(sessionExpiredText, "\n      </div>\n");
    }

    if (this.model.data.isDomainMismatch) {
      var domainMismatchText = this.model.i18n.domainMismatchText;
      innerHtml += "\n      <div class=\"login-notification login-notification-domain-mismatch login-notification-warning\">\n        ".concat(domainMismatchText, "\n      </div>\n");
    }

    if (loginMessage) {
      innerHtml += "\n      <div class=\"login-notification login-notification-admin-message\">\n        ".concat(loginMessage, "\n      </div>\n");
    }

    container.innerHTML = innerHtml;
  }
  /**
   * @returns {void}
   */


  initLoginForm() {
    this.formContainer.classList.toggle('hidden', true);
    this.formContainer.innerHTML = "\n    <form id=\"login-form\" class=\"login-form\">\n      <div id=\"login-form-inputs\" class=\"login-form-inputs\">\n        <input id=\"username-input\" class=\"username-input\">\n        <input id=\"password-input\" type=\"password\" class=\"password-input\">\n      </div>\n      <div id=\"login-form-error-container\" class=\"login-form-error-container\"></div>\n      <div id=\"login-form-buttons\" class=\"login-form-buttons\">\n        <button id=\"login-form-back-btn\" type=\"button\" class=\"login-form-button back-btn\"></button>\n        <button id=\"login-form-sign-in-btn\" type=\"submit\" class=\"login-form-button sign-in-btn\"></button>\n      </div>\n    </form>\n";
    this.usernameInput.placeholder = this.model.i18n.username;
    this.passwordInput.placeholder = this.model.i18n.password;
    this.formBackButton.innerHTML = '&lt; ' + this.model.i18n.back;
    this.formSignInButton.innerHTML = "\n    <div class=\"button-spinner\"></div>\n    <span>".concat(this.model.i18n.signInButton, "</span>\n");
    this.loginForm.addEventListener('submit', event => {
      if (this.state === State.FormError) {
        this.setState(State.Form);
      }

      this.submitForm();
      event.preventDefault();
      return false;
    });

    if (this.isOnlyBasicAuth) {
      var _this$formBackButton;

      (_this$formBackButton = this.formBackButton) === null || _this$formBackButton === void 0 || _this$formBackButton.remove();
    } else {
      this.formBackButton.addEventListener('click', event => {
        event.preventDefault();
        this.usernameInput.value = '';
        this.passwordInput.value = '';
        this.setState(State.Buttons);
        return false;
      });
    }
  }
  /**
   * @returns {void}
   */


  initFooter() {
    var privacyPolicyLabel = this.model.i18n.privacyPolicyLabel;
    var termsOfUseLabel = this.model.i18n.termsOfUseLabel;
    var versionLabel = this.model.i18n.versionLabel;
    var privacyPolicyUrl = this.model.data.privacyPolicyUrl;
    var termsOfUseUrl = this.model.data.termsOfUseUrl;
    var version = this.model.data.version;
    this.footer.classList.add('login-footer');
    var innerHtml = '';

    if (privacyPolicyUrl) {
      innerHtml += "\n    <a href=\"".concat(privacyPolicyUrl, "\" target=\"_top\" class=\"footer-link\">").concat(privacyPolicyLabel, "</a>\n    <span class=\"footer-separator\">|</span>\n");
    }

    if (termsOfUseUrl) {
      innerHtml += "\n      <a href=\"".concat(termsOfUseUrl, "\" target=\"_top\" class=\"footer-link\">").concat(termsOfUseLabel, "</a>\n      <span class=\"footer-separator\">|</span>\n");
    }

    innerHtml += "\n    <span class=\"footer-version\">".concat(versionLabel, " ").concat(version, "</span>\n");
    this.footer.innerHTML = innerHtml;
    var build = this.model.data.versionBuild;

    if (build) {
      var buildString = "".concat(this.model.i18n.versionBuild, ": ").concat(build);
      var footerVersion = this.footer.querySelector('.footer-version');
      this.applyMicrotip(footerVersion, buildString);
    }
  }
  /**
   * @returns {void}
   */


  initErrorContainer(message, refId) {
    var isContactInfo = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    this.signInHeader.textContent = this.model.i18n.authenticationError;
    var subheaderText = "\n    <span class=\"authentication-error-message\">".concat(message, "</span>\n");

    if (isContactInfo) {
      var contactInfo = this.model.i18n.authenticationErrorContactInfo;
      subheaderText += "\n      <span class=\"authentication-error-contact-info\">".concat(contactInfo, "</span>\n      <code class=\"authentication-error-state\">").concat(refId, "</code>\n");
    }

    this.signInSubheader.innerHTML = subheaderText;
    this.errorContainer.classList.toggle('hidden', true);
    this.errorContainer.innerHTML = "\n    <button id=\"error-back-btn\" class=\"back-btn\"></button>\n";
    this.errorBackButton.innerHTML = '&lt; ' + this.model.i18n.back;
    this.errorBackButton.addEventListener('click', () => {
      this.isAuthenticationErrorDismissed = true;
      this.setState(State.Init);
    });
  }

  setInitialState() {
    this.state = State.Init;
    this.stateMetadata = null;

    if (this.isAuthenticationError) {
      var _this$model$api$getAu2 = this.model.api.getAuthenticationError(),
          message = _this$model$api$getAu2.message,
          refId = _this$model$api$getAu2.refId,
          isContactInfo = _this$model$api$getAu2.isContactInfo;

      this.setState(State.Error, {
        message,
        refId,
        isContactInfo
      });
    } else {
      this.initSignInHeader();

      if (this.isOnlyBasicAuth) {
        this.setState(State.Form);
      } else {
        this.setState(State.Buttons);
      }
    }
  }

  setState(state, metadata) {
    var _StateTransitions$thi;

    if (!Object.values(State).includes(state)) {
      console.error("Custom frontpage: invalid state ".concat(state));
      return;
    }

    if (!((_StateTransitions$thi = StateTransitions[this.state]) !== null && _StateTransitions$thi !== void 0 && _StateTransitions$thi.includes(state)) && // check first time setting Init state (from undefined)
    !(!this.state && state === State.Init)) {
      console.error("Custom frontpage: invalid state transition ".concat(this.state, " -> ").concat(state));
      return;
    }

    var methodName = "handle".concat(state, "State");
    this[methodName](metadata); // Setting initial state ends with setting another state. Otherwise set the current
    // state.

    if (state !== State.Init) {
      this.state = state;
      this.stateMetadata = metadata !== null && metadata !== void 0 ? metadata : null;
    }
  } // --- Handlers for entering new state ---


  handleInitState() {
    this.setInitialState();
  }

  handleButtonsState() {
    this.signInSubheader.textContent = this.model.i18n.withIdentityProvider;
    this.toggleViews({
      buttonsContainer: true,
      messageContainer: true,
      formContainer: false,
      errorContainer: false
    });
    this.setAllAuthIconsSpinners(false);
  }

  handleFormState() {
    this.signInSubheader.textContent = this.model.i18n.usingUsername;
    this.toggleViews({
      buttonsContainer: false,
      messageContainer: true,
      formContainer: true,
      errorContainer: false,
      formErrorContainer: false
    });
    this.usernameInput.classList.toggle('has-error', false);
    this.passwordInput.classList.toggle('has-error', false);
    this.usernameInput.disabled = false;
    this.passwordInput.disabled = false;
    this.formSignInButton.disabled = false;
    this.formSignInButton.classList.toggle('loading', false);

    if (this.formBackButton) {
      this.formBackButton.disabled = false;
    }

    this.uninstallClearFormErrorListener();

    if (![this.usernameInput, this.passwordInput].includes(document.activeElement)) {
      this.usernameInput.focus();
    }
  }

  handleButtonAuthenticatingState(metadata) {
    this.setAuthIconSpinner(metadata.authenticatorName, true);
  }

  handleFormAuthenticatingState() {
    this.usernameInput.disabled = true;
    this.passwordInput.disabled = true;
    this.formSignInButton.disabled = true;
    this.formSignInButton.classList.toggle('loading', true);

    if (this.formBackButton) {
      this.formBackButton.disabled = true;
    }
  }

  handleErrorState(metadata) {
    this.initErrorContainer(metadata === null || metadata === void 0 ? void 0 : metadata.message, metadata === null || metadata === void 0 ? void 0 : metadata.refId, metadata === null || metadata === void 0 ? void 0 : metadata.isContactInfo);
    this.toggleViews({
      buttonsContainer: false,
      messageContainer: true,
      formContainer: false,
      errorContainer: true
    });
  }

  handleFormErrorState(metadata) {
    this.toggleViews({
      formErrorContainer: true
    });
    this.usernameInput.classList.toggle('has-error', true);
    this.passwordInput.classList.toggle('has-error', true);
    this.usernameInput.disabled = false;
    this.passwordInput.disabled = false;
    this.formSignInButton.disabled = false;
    this.formSignInButton.classList.toggle('loading', false);

    if (this.formBackButton) {
      this.formBackButton.disabled = false;
    }

    this.formErrorContainer.textContent = metadata.message || this.model.i18n.unknownError;
    this.installClearFormErrorListener();
  }

  installClearFormErrorListener() {
    if (this.clearFormErrorListener) {
      this.uninstallClearFormErrorListener();
    }

    var clearFormErrorListener = () => {
      this.setState(State.Form);
      this.uninstallClearFormErrorListener();
    };

    this.usernameInput.addEventListener('input', clearFormErrorListener);
    this.passwordInput.addEventListener('input', clearFormErrorListener);
    this.clearFormErrorListener = clearFormErrorListener;
  }

  uninstallClearFormErrorListener() {
    try {
      this.usernameInput.removeEventListener('input', this.clearFormErrorListener);
      this.passwordInput.removeEventListener('input', this.clearFormErrorListener);
    } finally {
      this.clearFormErrorListener = null;
    }
  }

  toggleView(viewName, isVisible) {
    /** @type {HTMLElement} */
    var element = this[viewName];

    if (!element) {
      return;
    }

    element.classList.toggle('hidden', !isVisible);
  }

  toggleViews(options) {
    for (var viewName in options) {
      this.toggleView(viewName, options[viewName]);
    }
  }

  submitForm() {
    this.model.api.usernameAuthenticate(this.usernameInput.value, this.passwordInput.value);
  }

  setAuthIconSpinner(authenticatorName, isLoading) {
    var button = this.buttonsContainer.querySelector(".login-icon-box.".concat(authenticatorName));

    if (!button) {
      return;
    }

    var authIconImage = button.querySelector('.auth-icon-image');
    var spinner = button.querySelector('.login-icon-spinner');
    authIconImage.classList.toggle('hidden', isLoading);
    spinner.classList.toggle('hidden', !isLoading);
  }

  setAllAuthIconsSpinners(isLoading) {
    var _iterator2 = _createForOfIteratorHelper(this.model.data.availableAuthenticators),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var id = _step2.value.id;
        this.setAuthIconSpinner(id, isLoading);
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  }
  /**
   * Custom front page uses Microtip library (https://github.com/ghosh/microtip) which
   * adds support for displaying CSS-based tooltips. This method adds a tooltip shown
   * when element is hovered.
   * @param {HTMLElement} element
   * @param {string} text
   * @param {'top'|'top-left'|'top-right'|'bottom'|'bottom-left'|'bottom-right'|'left'|'right'} position
   */


  applyMicrotip(element, text) {
    var position = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'top';
    element.role = 'tooltip';
    element.ariaLabel = text;
    element.setAttribute('data-microtip-position', position);
  }

}

(function main() {
  var frontpageApi = new FrontpageApi();
  frontpageApi.mountFrontpage();
  frontpageApi.setState(State.Init);
})();