#pragma once

#include <folly/ConcurrentSkipList.h>
#include <folly/FBString.h>
#include <folly/concurrency/ConcurrentHashMap.h>
#include <folly/io/async/AsyncSocket.h>

namespace rtransfer {

namespace proto {
constexpr std::size_t header_size = 9;
constexpr std::size_t version_size = 2;
constexpr std::size_t secret_size = 64;
constexpr std::size_t ctrlid_size = 16;
constexpr std::size_t handshake_size =
    header_size + version_size + secret_size + ctrlid_size;
constexpr std::uint8_t last_part_mask = 1u << 7;
class LinkMessage;
}  // namespace proto

class Storage;
class ServerSideLink;
namespace client {
class Client;
}

using MsgPtr = std::unique_ptr<proto::LinkMessage>;

using ServerLinksMap = folly::ConcurrentHashMap<folly::fbstring,
    std::weak_ptr<rtransfer::ServerSideLink>>;

using ClientLinksMap = folly::ConcurrentHashMap<folly::fbstring,
    std::shared_ptr<rtransfer::client::Client>>;

using StoragesMap = folly::ConcurrentHashMap<folly::fbstring,
    std::shared_ptr<rtransfer::Storage>>;

class SecretManager;

namespace common {

inline std::shared_ptr<folly::AsyncSocket> setNoDelay(
    const char* what, std::shared_ptr<folly::AsyncTransport> transport)
{
    auto sock = std::dynamic_pointer_cast<folly::AsyncSocket>(transport);
    CHECK(sock);
    LOG_IF(WARNING, sock->setNoDelay(true))
        << "Failed to set nodelay on " << what;
    return sock;
}

}  // namespace common
}  // namespace rtransfer
