#pragma once

#include <folly/Likely.h>

#include <array>

// Reimplementation of
// https://github.com/torvalds/linux/blob/master/lib/win_minmax.c

namespace rtransfer {

template <typename T, typename Comp, typename Time, typename Duration>
class MinMaxWindow {
public:
    MinMaxWindow(Duration window)
        : window_{window}
    {
    }

    void setWindow(Duration window) { window_ = window; }

    T add(T val, Time t)
    {
        Node node{val, t};

        if (UNLIKELY(Comp{}(node.val, vals_.front().val)) ||
            UNLIKELY(node.t - vals_.back().t > window_))
            vals_.fill(node);

        if (UNLIKELY(Comp{}(node.val, vals_[1].val)))
            vals_[2] = vals_[1] = node;
        else if (UNLIKELY(Comp{}(node.val, vals_[2].val)))
            vals_[2] = node;

        auto dt = node.t - vals_.front().t;
        if (UNLIKELY(dt > window_)) {
            vals_[0] = vals_[1];
            vals_[1] = vals_[2];
            vals_[2] = node;
            if (UNLIKELY(node.t - vals_.front().t > window_)) {
                vals_[0] = vals_[1];
                vals_[1] = vals_[2];
                vals_[2] = node;
            }
        }
        else if (UNLIKELY(vals_[1].t == vals_[0].t) && dt > window_ / 4) {
            vals_[2] = vals_[1] = node;
        }
        else if (UNLIKELY(vals_[2].t == vals_[1].t) && dt > window_ / 2) {
            vals_[2] = node;
        }

        return vals_.front().val;
    }

    T get() const { return vals_.front().val; }

private:
    struct Node {
        T val;
        Time t;
    };

    std::array<Node, 3> vals_{};
    Duration window_;
};

}  // namespace rtransfer
