#pragma once

#include "common.hpp"
#include "handleCache.hpp"
#include "serverSideLink.hpp"
#include "storage.hpp"

#include <folly/Bits.h>
#include <folly/SpinLock.h>
#include <folly/futures/Future.h>
#include <folly/io/IOBuf.h>
#include <folly/io/IOBufQueue.h>
#include <monitoring/monitoring.h>

#include <cstdint>
#include <memory>

namespace rtransfer {

class Reader {
public:
    Reader(StoragesMap &storages, HandleCache &handleCache,
        std::shared_ptr<ServerSideLink> serverLink);

    folly::Future<std::size_t> read(std::uint64_t reqId,
        folly::fbstring storageId, folly::fbstring fileId,
        folly::fbstring fileGuid, std::uint64_t offset, std::size_t size,
        std::uint8_t priority);

private:
    struct SendTask {
        folly::Promise<folly::Unit> promise;
        folly::IOBufQueue buf;
        std::uint64_t reqId;
        std::uint64_t offset;
        std::uint8_t priority;
    };

    static std::unique_ptr<folly::IOBuf> constructDataMsg(std::uint64_t reqId,
        std::uint64_t offset, std::uint8_t part, bool isLastPart,
        std::unique_ptr<folly::IOBuf> buf);

    void startSending();

    void doStartSending();

    folly::fbvector<std::pair<ServerSideLink::Conn, folly::IOBuf *>>
    connsForPrio(folly::fbvector<std::pair<ServerSideLink::Conn,
                     std::unique_ptr<folly::IOBuf>>> &allConnsToData,
        std::uint8_t prio);

    void distributeParts(folly::fbvector<std::pair<ServerSideLink::Conn,
                             std::unique_ptr<folly::IOBuf>>> &connsToData,
        SendTask &sendTask);

    std::vector<folly::Future<folly::Unit>> sendParts(
        folly::fbvector<std::pair<ServerSideLink::Conn,
            std::unique_ptr<folly::IOBuf>>> &connsToData);

    folly::fbvector<SendTask> queuedSendTasks_;
    folly::fbvector<SendTask> usedSendTasks_;
    bool sendInProgress_ = false;
    folly::SpinLock spinLock_;

    StoragesMap &storages_;
    HandleCache &handleCache_;
    std::shared_ptr<ServerSideLink> serverLink_;
};

}  // namespace rtransfer
