#pragma once

#include "authCache.hpp"
#include "common.hpp"
#include "controlService.hpp"
#include "proto/rtransfer_messages.pb.h"
#include "reader.hpp"
#include "shaper.hpp"
#include "shaperMap.hpp"

#include <wangle/service/Service.h>

namespace rtransfer {

class Service : public wangle::Service<std::unique_ptr<proto::LinkMessage>,
                    std::unique_ptr<proto::LinkMessage>> {
public:
    using MsgPtr = std::unique_ptr<proto::LinkMessage>;

    Service(StoragesMap &storages, link_control::ControlService &controlService,
        std::shared_ptr<ServerSideLink> serverLink, folly::fbstring providerId)
        : providerId_{std::move(providerId)}
        , reader_{storages, handleCache_, serverLink}
        , shaperMap_{reader_}
        , authCache_{controlService}
    {
    }

    folly::Future<MsgPtr> operator()(MsgPtr request) override;

private:
    folly::Future<MsgPtr> action(MsgPtr request);
    folly::Future<MsgPtr> fetch(MsgPtr request);
    folly::Future<MsgPtr> ack(MsgPtr request);
    folly::Future<MsgPtr> cancel(MsgPtr request);
    folly::Future<MsgPtr> ping(MsgPtr request);
    static folly::Future<MsgPtr> error(folly::StringPiece description);

    folly::fbstring providerId_;
    HandleCache handleCache_;
    Reader reader_;
    ShaperMap shaperMap_;
    AuthCache authCache_;
};

class ServiceFactory {
public:
    ServiceFactory(
        StoragesMap &storages, link_control::ControlService &controlService)
        : storages_{storages}
        , controlService_{controlService}
    {
    }

    std::shared_ptr<Service> operator()(
        std::shared_ptr<ServerSideLink> serverLink, folly::fbstring providerId)
    {
        return std::make_shared<Service>(
            storages_, controlService_, serverLink, std::move(providerId));
    }

private:
    StoragesMap &storages_;
    link_control::ControlService &controlService_;
};

}  // namespace rtransfer
