#pragma once

#include "common.hpp"
#include "periodicHandler.hpp"
#include "shaper.hpp"
#include "shaperTimer.hpp"

#include <folly/Hash.h>
#include <folly/concurrency/ConcurrentHashMap.h>
#include <folly/executors/SerialExecutor.h>
#include <folly/futures/Future.h>
#include <wangle/channel/Handler.h>
#include <wangle/service/Service.h>

#include <chrono>
#include <unordered_map>

namespace rtransfer {

class Reader;

class ShaperMap {
public:
    ShaperMap(Reader &reader);

    folly::Future<std::size_t> fetch(MsgPtr msg);

    folly::Future<folly::Unit> cancel(MsgPtr msg);

    void ack(MsgPtr msg);

private:
    folly::ConcurrentHashMap<
        std::tuple<folly::fbstring, folly::fbstring, std::uint8_t>,
        std::shared_ptr<Shaper>>
        shapers_;

    folly::ConcurrentHashMap<std::uint64_t, std::shared_ptr<Shaper>>
        reqToShaper_;

    Reader &reader_;
    ShaperTimer<std::chrono::steady_clock> shaperTimer_;
};

}  // namespace rtransfer
