#include "shaperTimer.hpp"

#include "shaper.hpp"

namespace rtransfer {

template <class Clock>
ShaperTimer<Clock>::ShaperTimer()
{
    worker_ = std::thread{[this] { run(); }};
}

template <class Clock>
ShaperTimer<Clock>::~ShaperTimer()
{
    {
        std::lock_guard<std::mutex> guard{mtx_};
        running_ = false;
        nextWork_.notify_one();
    }
    worker_.join();
}

template <class Clock>
void ShaperTimer<Clock>::scheduleSendPacket(
    typename Clock::time_point when, Shaper *what)
{
    std::lock_guard<std::mutex> guard{mtx_};
    queue_.emplace(when, what);
    if (queue_.top().first == when)
        nextWork_.notify_one();
}

template <class Clock>
void ShaperTimer<Clock>::run()
{
    std::unique_lock<std::mutex> lock{mtx_};

    while (running_) {
        while (queue_.empty()) {
            nextWork_.wait(lock);
            if (!running_)
                return;
        }
        auto now = Clock::now();
        do {
            auto after = queue_.top().first - now;
            if (after > std::chrono::milliseconds::zero()) {
                nextWork_.wait_for(lock, after);
                break;
            }
            queue_.top().second->scheduledSendPacket();
            queue_.pop();
        } while (!queue_.empty());
    }
}

}  // namespace rtransfer

template class rtransfer::ShaperTimer<std::chrono::steady_clock>;
template class rtransfer::ShaperTimer<std::chrono::high_resolution_clock>;
