#pragma once

#include <folly/FBVector.h>

#include <chrono>
#include <condition_variable>
#include <mutex>
#include <queue>
#include <thread>

namespace rtransfer {

class Shaper;

template <class Clock>
class ShaperTimer {
public:
    ShaperTimer();

    ~ShaperTimer();

    void scheduleSendPacket(typename Clock::time_point when, Shaper *what);

private:
    void run();

    using T = std::pair<typename Clock::time_point, Shaper *>;
    std::priority_queue<T, folly::fbvector<T>> queue_;

    bool running_ = true;
    std::thread worker_;
    std::condition_variable nextWork_;
    std::mutex mtx_;
};

}  // namespace rtransfer

extern template class rtransfer::ShaperTimer<std::chrono::steady_clock>;
extern template class rtransfer::ShaperTimer<
    std::chrono::high_resolution_clock>;
